/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.actionControllers;

import com.aptana.configurations.processor.ConfigurationStatus;
import com.aptana.core.logging.IdeLog;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.BrowserNotifier;
import com.aptana.portal.ui.dispatch.IBrowserNotificationConstants;
import com.aptana.portal.ui.dispatch.actionControllers.AbstractActionController;
import com.aptana.portal.ui.dispatch.actionControllers.ControllerAction;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceActionController
extends AbstractActionController {
    private static final String VALUE = "value";
    private static final String KEY = "key";

    @ControllerAction
    public Object getPreferenceValue(Object arguments) {
        Object check = this.checkArguments(arguments);
        if (check != null) {
            return check;
        }
        IPreferenceStore preferenceStore = PortalUIPlugin.getDefault().getPreferenceStore();
        try {
            Map map = (Map)((Object[])arguments)[0];
            return preferenceStore.getString((String)map.get(KEY));
        }
        catch (Throwable t) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)t);
            return IBrowserNotificationConstants.JSON_ERROR;
        }
    }

    @ControllerAction
    public Object setPreferenceValue(Object arguments) {
        Object check = this.checkArguments(arguments);
        if (check != null) {
            return check;
        }
        IPreferenceStore preferenceStore = PortalUIPlugin.getDefault().getPreferenceStore();
        try {
            Map map = (Map)((Object[])arguments)[0];
            preferenceStore.setValue((String)map.get(KEY), Boolean.parseBoolean((String)map.get(VALUE)));
        }
        catch (Throwable t) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)t);
            return IBrowserNotificationConstants.JSON_ERROR;
        }
        return IBrowserNotificationConstants.JSON_OK;
    }

    private Object checkArguments(Object arguments) {
        if (!(arguments instanceof Object[])) {
            String message = "Wrong argument type passed to PreferenceActionController::setPreferenceValue. Expected Object[] and got " + (arguments == null ? "null" : arguments.getClass().getName());
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
            return BrowserNotifier.toJSONErrorNotification("Argument Error", null);
        }
        Object[] arr = (Object[])arguments;
        if (arr.length != 1 || !(arr[0] instanceof Map)) {
            String message = "Wrong argument type passed to PreferenceActionController::setPreferenceValue. Expected a Map in the object array";
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
            return BrowserNotifier.toJSONErrorNotification("Argument Error", null);
        }
        return null;
    }

    public void configurationStateChanged(ConfigurationStatus status, Set<String> attributesChanged) {
    }
}

